<?php

namespace GoDaddy\WordPress\MWC\Core\Features\SequentialOrderNumbers\Events;

use GoDaddy\WordPress\MWC\Common\Events\Contracts\EventBridgeEventContract;
use GoDaddy\WordPress\MWC\Common\Traits\IsEventBridgeEventTrait;
use function GoDaddy\WordPress\MWC\SequentialOrderNumbers\wc_seq_order_number_pro;

/**
 * Settings updated event class.
 *
 * @since 2.10.0
 */
class SequentialOrderNumbersSettingsUpdatedEvent implements EventBridgeEventContract
{
    use IsEventBridgeEventTrait;

    /**
     * SequentialOrderNumbersSettingsUpdatedEvent constructor.
     */
    public function __construct()
    {
        $this->resource = 'sequential_order_numbers_settings';
        $this->action = 'update';
    }

    /**
     * Gets the data for the event.
     *
     * @return array
     */
    public function getData() : array
    {
        $plugin = wc_seq_order_number_pro();

        return [
            'starting_number' => $plugin->get_order_number_start(),
            'prefix' => $plugin->get_order_number_prefix(),
            'suffix' => $plugin->get_order_number_suffix(),
            'skip_free_orders' => $plugin->skip_free_orders(),
            'free_orders_prefix' => $plugin->get_free_order_number_prefix(),
        ];
    }
}
