---
id: contributing
title: Contributing
---

## Issues and Bugs

We encourage active team collaboration and contribution to this code base.  If you have discovered an issue or edge case within the library, it is strongly encouraged to submit a pull request in order to resolve that issue.

:::note Minimum Expectations
If you are unable to fix the issue yourself, you are expected to **at a minimum** provide a pull request with a failing test for the given scenario!
:::

When providing a pull request to resolve an issue in this library, you should be ideally providing the following in conjunction with the [pull request template](https://github.com/gdcorp-partners/mwc-payments/blob/main/.github/pull_request_template.md):

- A clear description of the issue
- A failing test demonstrating the issue
- A description of what would you expect the functionality to produce if the bug did not exist

The above is required in the hope that team members experiencing the same problem are able to collaborate quickly for a clear resolution, in addition to, ensuring the problem and expectations are clearly defined.

## Coding Style

Contributions to this library should conform to [PSR](https://github.com/php-fig/fig-standards/tree/master/accepted) coding standards and the [PSR-4](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-4-autoloader.md) autoloading standard.

:::note Coding Style Standards
[PSR-2](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md) sets out the general code style standards.  In addition, [PSR Naming Conventions](https://www.php-fig.org/bylaws/psr-naming-conventions/) are explicitly set out to follow standard patterns and should be adhered to.
:::
